/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.sfp.surveillance;

import com.ibm.hsc.auiml.databeans.sfp.SFPException;
import com.ibm.hsc.auiml.databeans.sfp.data.StructuredData;
import com.ibm.hsc.ccfw.pa.event.SurveillanceNotificationDataEvent;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.sfp.surveillance.Surveillance;
import com.ibm.hsc.sfp.surveillance.SurveillanceEvent;
import com.ibm.hsc.sfp.surveillance.SurveillanceEventList;
import com.ibm.hsc.sfp.surveillance.SurveillanceEventType;
import com.ibm.hsc.sfp.surveillance.SurveillancePartitionConnectionState;
import com.ibm.hsc.sfp.surveillance.SurveillancePartitionStateList;
import com.ibm.hsc.sfp.surveillance.SurveillanceTimerThreadState;
import com.ibm.hwmca.base.pa.domain.ConsoleAnalysisDomain;
import com.ibm.hwmca.base.pa.system.ConsoleSystem;
import com.ibm.hwmca.fw.domain.DomainManager;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.xfw.pa.system.RemotePartitionSystem;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;

public class SurveillanceTimerThread
implements Runnable {
    private static final String TRACE_MASKD = "JSURVTTD";
    private static final String TRACE_MASKF = "JSURVTTF";
    private static final String TRACE_MASKT = "JSURVTTT";
    private static final Locale ENGLISH_US = new Locale(Locale.ENGLISH.getLanguage(), Locale.US.getCountry());
    private SurveillanceTimerThreadState state = SurveillanceTimerThreadState.NOT_RUNNING;
    private SurveillanceEventList eventList;
    private SurveillancePartitionStateList partitionStates;
    private Surveillance surveillance;

    SurveillanceTimerThread(SurveillanceEventList surveillanceEventList, SurveillancePartitionStateList surveillancePartitionStateList, Surveillance surveillance) {
        this.eventList = surveillanceEventList;
        this.partitionStates = surveillancePartitionStateList;
        this.surveillance = surveillance;
    }

    public static void main(String[] stringArray) {
        SurveillanceEventList surveillanceEventList = null;
        SurveillancePartitionStateList surveillancePartitionStateList = null;
        Surveillance surveillance = null;
        SurveillanceEvent surveillanceEvent = null;
        String string = "0001";
        String string2 = "partition1";
        String string3 = "partition1.endicott.ibm.com";
        Date date = new Date();
        SurveillanceEventType surveillanceEventType = SurveillanceEventType.DISCONNECT;
        String string4 = "1234-123";
        String string5 = "1234567";
        String string6 = "ZZZZ";
        String string7 = "5678-123";
        String string8 = "7654321";
        surveillance = new Surveillance();
        surveillancePartitionStateList = new SurveillancePartitionStateList(surveillance);
        surveillanceEvent = new SurveillanceEvent(string, string2, string3, date, surveillanceEventType, string4, string5, string6, string7, string8, null);
        surveillanceEventList = new SurveillanceEventList(surveillance, surveillancePartitionStateList);
        new SurveillanceTimerThread(surveillanceEventList, surveillancePartitionStateList, surveillance).processSE(surveillanceEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        long l = 0L;
        Date date = null;
        while (true) {
            try {
                while (true) {
                    SurveillanceEventList surveillanceEventList = this.eventList;
                    synchronized (surveillanceEventList) {
                        try {
                            date = (Date)this.eventList.firstKey();
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            date = null;
                        }
                        if (date != null) {
                            l = date.getTime() - new Date().getTime();
                            if (3 <= Trace.LEVEL) {
                                Trace.trace(TRACE_MASKD, "Timer thread found first entry with timeout of " + l);
                            }
                            if (l > 0L) {
                                if (3 <= Trace.LEVEL) {
                                    Trace.trace(TRACE_MASKD, "Timer thread starting to sleep for " + l + " milliseconds or until notified.");
                                }
                                try {
                                    this.eventList.wait(l);
                                    if (3 <= Trace.LEVEL) {
                                        Trace.trace(TRACE_MASKD, "Timer thread woke up.");
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (this.eventList.isEmpty()) {
                            this.setState(SurveillanceTimerThreadState.NOT_RUNNING);
                            return;
                        }
                        this.processList();
                    }
                }
            }
            catch (Throwable throwable) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Throwable caught in timer thread: " + throwable);
                }
                new AusMicrocodeLog(Surveillance.SURVEILLANCE_TIMER_THREAD_LOG_INFO, 8, throwable).writeEntry(null);
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    void setState(SurveillanceTimerThreadState surveillanceTimerThreadState) {
        if (3 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKD, "State of timer thread being set to " + surveillanceTimerThreadState);
        }
        this.state = surveillanceTimerThreadState;
    }

    SurveillanceTimerThreadState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeup() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> wakeup()");
        }
        SurveillanceEventList surveillanceEventList = this.eventList;
        synchronized (surveillanceEventList) {
            this.eventList.notify();
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- wakeup()");
        }
    }

    private void processList() {
        Date date = null;
        Set set = null;
        Date date2 = null;
        SurveillanceEvent surveillanceEvent = null;
        Vector<SurveillanceEvent> vector = null;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> processList()");
        }
        date = new Date();
        set = this.eventList.keySet();
        vector = new Vector<SurveillanceEvent>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            date2 = (Date)iterator.next();
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "comparing key of " + StructuredData.TS_FORMATTER.format(date2) + " to current time of " + StructuredData.TS_FORMATTER.format(date));
            }
            if (date2.compareTo(date) > 0) continue;
            Iterator iterator2 = ((Vector)this.eventList.get(date2)).iterator();
            while (iterator2.hasNext()) {
                surveillanceEvent = (SurveillanceEvent)iterator2.next();
                this.process(surveillanceEvent, date2);
                if (!surveillanceEvent.getType().equals(SurveillanceEventType.CONNECT) || surveillanceEvent.getAdapter() != null) continue;
                vector.add(surveillanceEvent);
            }
            iterator.remove();
            if (3 > Trace.LEVEL) continue;
            this.eventList.doDebug("removed event so the events are now : ");
        }
        iterator = vector.iterator();
        while (iterator.hasNext()) {
            surveillanceEvent = (SurveillanceEvent)iterator.next();
            this.eventList.delete(surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS(), surveillanceEvent.getPartitionId(), SurveillanceEventType.NOT_YET_CONNECTED, null);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- processList()");
        }
    }

    private void process(SurveillanceEvent surveillanceEvent, Date date) {
        SurveillancePartitionConnectionState surveillancePartitionConnectionState = null;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> process(" + surveillanceEvent + ", " + date + ")");
        }
        if (surveillanceEvent.getType().equals(SurveillanceEventType.CONNECT)) {
            this.partitionStates.setStableConnectionState(surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS(), surveillanceEvent.getPartitionId(), SurveillancePartitionConnectionState.CONNECTED, surveillanceEvent.getAdapter());
        } else if (surveillanceEvent.getType().equals(SurveillanceEventType.DISCONNECT)) {
            surveillancePartitionConnectionState = this.partitionStates.getStableConnectionState(surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS(), surveillanceEvent.getPartitionId(), surveillanceEvent.getAdapter());
            if (surveillancePartitionConnectionState != null && surveillancePartitionConnectionState.equals(SurveillancePartitionConnectionState.CONNECTED) && this.surveillance.doSurveillancePerConfig(surveillanceEvent.getPartitionId(), surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS()) && surveillanceEvent.getPartitionCIMState() != null && surveillanceEvent.getPartitionCIMState().intValue() == 2 && !surveillanceEvent.getBecameNotRunning()) {
                this.processSE(surveillanceEvent);
            }
            this.partitionStates.setStableConnectionState(surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS(), surveillanceEvent.getPartitionId(), SurveillancePartitionConnectionState.NOT_CONNECTED, surveillanceEvent.getAdapter());
        } else if (surveillanceEvent.getType().equals(SurveillanceEventType.NOT_YET_CONNECTED) && this.surveillance.doSurveillancePerConfig(surveillanceEvent.getPartitionId(), surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS()) && surveillanceEvent.getPartitionCIMState() != null && surveillanceEvent.getPartitionCIMState().intValue() == 2 && !surveillanceEvent.getBecameNotRunning()) {
            this.processSE(surveillanceEvent);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- process()");
        }
    }

    private void processSE(SurveillanceEvent surveillanceEvent) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> processSE(" + surveillanceEvent + ")");
        }
        try {
            this.createSE(surveillanceEvent);
        }
        catch (SFPException sFPException) {
            new AusMicrocodeLog(Surveillance.SURVEILLANCE_TIMER_THREAD_LOG_INFO, 0, sFPException).writeEntry(null);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- processSE(" + surveillanceEvent + ")");
        }
    }

    private void createSE(SurveillanceEvent surveillanceEvent) throws SFPException {
        SurveillanceNotificationDataEvent surveillanceNotificationDataEvent = null;
        ConsoleSystem consoleSystem = null;
        RemotePartitionSystem remotePartitionSystem = null;
        ConsoleAnalysisDomain consoleAnalysisDomain = null;
        DomainManager domainManager = null;
        domainManager = DomainManager.getDomainManager();
        if (domainManager != null) {
            consoleAnalysisDomain = (ConsoleAnalysisDomain)domainManager.get(ConsoleAnalysisDomain.CAD_DOMAINID);
            if (consoleAnalysisDomain == null) {
                throw new SFPException("Cannot get HMC console domain.");
            }
        } else {
            throw new SFPException("Cannot get Problem Analysis Domain Manager.");
        }
        consoleSystem = consoleAnalysisDomain.getConsoleSystem();
        remotePartitionSystem = new RemotePartitionSystem(SurveillanceTimerThread.getMachineType(surveillanceEvent.getCECMTM()), SurveillanceTimerThread.getMachineModel(surveillanceEvent.getCECMTM()), surveillanceEvent.getCECMS(), surveillanceEvent.getPartitionName(), surveillanceEvent.getPartitionId(), surveillanceEvent.getHostName());
        surveillanceNotificationDataEvent = new SurveillanceNotificationDataEvent(this);
        if (surveillanceEvent.getAdapter() == null) {
            surveillanceNotificationDataEvent.setFailureReason(4);
        } else {
            surveillanceNotificationDataEvent.setFailureReason(8);
        }
        surveillanceNotificationDataEvent.setEndPointA((PASystem)consoleSystem);
        surveillanceNotificationDataEvent.setEndPointB((PASystem)remotePartitionSystem);
        surveillanceNotificationDataEvent.setSRC(surveillanceEvent.getErrorCode());
        surveillanceNotificationDataEvent.setSvcEventText(Surveillance.getTranslatedErrorText(ENGLISH_US, surveillanceEvent.getErrorCode(), surveillanceEvent.getPartitionName(), false, surveillanceEvent.getHMCMS()));
        surveillanceNotificationDataEvent.log();
    }

    private static String getMachineType(String string) {
        int n = 0;
        String string2 = "";
        if (string != null && (n = string.indexOf(45)) > 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private static String getMachineModel(String string) {
        int n = 0;
        String string2 = "";
        if (string != null && (n = string.indexOf(45)) >= 0 && n < string.length() - 1) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }
}

